// AddAccessLevel.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "AddAccessLevel.h"
#include <comdef.h>
#include<atlbase.h>
#include <afxtempl.h>
#define MAXLEN 255

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddAccessLevel dialog



CAddAccessLevel::CAddAccessLevel(CWnd* pParent /*=NULL*/)
	: CDialog(CAddAccessLevel::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddAccessLevel)
	m_Acclname = _T("");
	m_Accldesc = _T("");
	//}}AFX_DATA_INIT
}

CAddAccessLevel ::CAddAccessLevel(IApplication *pApp):CDialog(CAddAccessLevel::IDD, NULL)
{
	pApplication = pApp;
	pAccl.CreateInstance(__uuidof(AccessLevel));
	
}
void CAddAccessLevel::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddAccessLevel)
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAcctList);
	DDX_Control(pDX, IDC_ADDACCESS_SUBACCT, m_EditSubAcctList);
	DDX_Text(pDX, IDC_ADDACCESS_NAME, m_Acclname);
	DDX_Text(pDX, IDC_ADDACCESS_DESC, m_Accldesc);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAddAccessLevel, CDialog)
	//{{AFX_MSG_MAP(CAddAccessLevel)
	
	ON_BN_CLICKED(ID_ADD, OnAdd)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
		
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddAccessLevel message handlers

BOOL CAddAccessLevel::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE

}
void CAddAccessLevel :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctID;
				sAcctID.Format(_T("%ld"),pAccount->AccountID);
				m_AcctList.AddString(sAcctID);
				pAccount->Release();
			}
			pDisp->Release();
		}
		//m_AcctList.SetCurSel(0);
	UpdateData(FALSE);
}

void CAddAccessLevel :: LoadSubAccounts(long lAcctID)
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
		pApplication->GetSubAccountsByAccountID(lAcctID,&vSubAccounts); // get subaccount details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pSubAccount = NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount != NULL)
			{
				m_SubAcctList.AddString(pSubAccount->AccountName);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
		//m_AcctList.SetCurSel(0);
	UpdateData(FALSE);
}

void CAddAccessLevel :: LoadSubAccountNames(long lAcctID)
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
		pApplication->GetSubAccountsByAccountID(lAcctID,&vSubAccounts); // get subaccount details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pSubAccount = NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount != NULL)
			{
				m_EditSubAcctList.AddString(pSubAccount->AccountName);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
		//m_AcctList.SetCurSel(0);
	UpdateData(FALSE);
}

void CAddAccessLevel::OnSelchangeAcctlist() 
{
	int index_Acct = m_AcctList.GetCurSel();
	CString sAcctid;

	m_AcctList.GetLBText(index_Acct,sAcctid);
	long lAccountID = _wtoi(sAcctid);

	m_SubAcctList.ResetContent();
	LoadSubAccounts(lAccountID);
	LoadSubAccountNames(lAccountID);
}

void CAddAccessLevel::OnAdd() 
{
		BSTR bstrAcctName;
		BSTR bstrSubAcctName;
		BSTR bstrAcclName;
		BSTR bstrAcclDesc;

		UpdateData(TRUE);
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAccountID = _wtol(sAcctID);
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
		
		//select subaccount name 
		int index_SubAccount = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		if (index_SubAccount <0)
			bstrSubAcctName = SysAllocString(L"");
		else
		{
			m_SubAcctList.GetLBText(index_SubAccount,sSubAcctName);
			bstrSubAcctName = sSubAcctName.AllocSysString();
		}
		
		//get the access level name and description
		bstrAcclName = m_Acclname.AllocSysString();
		bstrAcclDesc = m_Accldesc.AllocSysString();
	//set Access level properties
		pAccl->AccountName		= bstrAcctName;
		pAccl->AccessLevelName	= bstrAcclName;
		pAccl->AccessLevelDesc	= bstrAcclDesc;


		CArray<int,int> SubAcctsels;
		VARIANT vSubAccounts;
		int nSubAcct = m_EditSubAcctList.GetSelCount();
		if (nSubAcct <= 0)
		{
			AfxMessageBox(L"Select SubAccount from the SubAccounts List");
			return;
		}
		COleSafeArray saSubAccounts;
		saSubAccounts.CreateOneDim(VT_BSTR,nSubAcct);
		SubAcctsels.SetSize(nSubAcct);
		m_EditSubAcctList.GetSelItems(nSubAcct, SubAcctsels.GetData());
		for(long j = 0; j < nSubAcct; j++)                                                  
		{                                                      
			CString sSubAcctName;       
			_bstr_t bstrSubAcctName;
			m_EditSubAcctList.GetText(SubAcctsels[j], sSubAcctName);
			bstrSubAcctName = sSubAcctName.AllocSysString();
			saSubAccounts.PutElement(&j,static_cast<BSTR>(bstrSubAcctName));
		}
		vSubAccounts = saSubAccounts.Detach();
		
		pAccl->SubAccountNames  = vSubAccounts;

		//add access level;
		long lStatus;
		pApplication->AddAccessLevel(pAccl,&lStatus);

		if (lStatus == 105)
		{
			AfxMessageBox(L"InValid Account/SubAccount name");
			return;
		}
		if(lStatus == 201)
		{
			AfxMessageBox(L"InValid Access level name");
			return;
		}
		if (lStatus == 206)
		{
			AfxMessageBox(L"Invalid Accesslevel Name / Description string length");
			return;
		}
		if ( lStatus == 202)
		{
			AfxMessageBox(L"AccessLevel Name Exists");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"AccessLevel Addition Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Access level Addition succeded");
			CDialog::OnOK();
		}
		UpdateData(FALSE);

		
}
